/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.loadmyresources.pack;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.keksuccino.loadmyresources.LoadMyResources;
import de.keksuccino.loadmyresources.pack.PackHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

public class LMRPackResources
extends FolderPackResources {
    public LMRPackResources() {
        super(PackHandler.resourcesDirectory);
    }

    public String m_8017_() {
        return "loadmyresources.hiddenpack";
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) throws IOException {
        Object o;
        try (InputStream in = Minecraft.m_91087_().m_91098_().m_142591_(PackHandler.DUMMY_PACK_META).m_6679_();){
            o = LMRPackResources.m_10214_(serializer, (InputStream)in);
        }
        return (T)o;
    }

    public Set<String> m_5698_(PackType type) {
        HashSet s = Sets.newHashSet();
        File[] files = this.f_10203_.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (files != null) {
            for (File f : files) {
                String path = LMRPackResources.m_10217_((File)this.f_10203_, (File)f);
                if (path.equals(path.toLowerCase(Locale.ROOT))) {
                    s.add(path.substring(0, path.length() - 1));
                    continue;
                }
                this.m_10230_(path);
            }
        }
        return s;
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        return this.m_5541_(LMRPackResources.getPathFromLocation(location));
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        return this.m_6105_(LMRPackResources.getPathFromLocation(location));
    }

    private static String getPathFromLocation(ResourceLocation location) {
        return String.format("%s/%s", location.m_135827_(), location.m_135815_());
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String namespace, String resourcePreNamePath, int depth, Predicate<String> predicate) {
        ArrayList l = Lists.newArrayList();
        this.listResources(new File(new File(this.f_10203_, namespace), resourcePreNamePath), depth, namespace, l, resourcePreNamePath + "/", predicate);
        return l;
    }

    private void listResources(File dir, int depth, String namespace, List<ResourceLocation> resourceList, String resourcePreNamePath, Predicate<String> predicate) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    if (depth <= 0) continue;
                    this.listResources(f, depth - 1, namespace, resourceList, resourcePreNamePath + f.getName() + "/", predicate);
                    continue;
                }
                if (f.getName().endsWith(".mcmeta") || !predicate.test(f.getName())) continue;
                try {
                    resourceList.add(new ResourceLocation(namespace, resourcePreNamePath + f.getName()));
                }
                catch (ResourceLocationException resourcelocationexception) {
                    LoadMyResources.LOGGER.error(resourcelocationexception.getMessage());
                }
            }
        }
    }

    public boolean isHidden() {
        return true;
    }
}

